<?php

namespace RtmMail;

/**
 * Settings - handles every user interaction for the settings page
 */
class Settings extends AbstractPage
{
    protected $slug = 'settings';

    public function __construct()
    {
        parent::__construct();
    }

    /**
     * handle_requests - every page can handle their requests (post/get)
     */
    public function handle_requests()
    {
        // Check if the user is on the settings page
        if ($this->page_check()) {
            // Check for save settings post request
            if (isset($_POST['save_settings'])) {
                // Verify if the post is from the right source
                if (wp_verify_nonce($_POST['_wpnonce'], 'rtm_mail_save_settings')) {
                    // Get previous settings
                    $mail_capability = $_POST['mail_capability'];

                    // Save to option table
                    update_option('rtm_mail_settings', [
                        'mail_capability' => $mail_capability,
                    ]);

                    // Send notification
                    echo '<div class="notice notice-success"> ';
                    echo '<p><strong>WP Mail Logger: </strong>';
                    echo __('Settings successfully saved!', 'rtm-mail');
                    echo '</p>';
                    echo '</div>';
                } else {
                    // Quit when invalid nonce
                    echo '<div class="notice notice-error"> ';
                    echo '<p><strong>WP Mail Logger: </strong>';
                    echo __('Invalide nonce!', 'rtm-mail');
                    echo '</p>';
                    echo '</div>';
                }
            }
        }
    }
}
