jQuery(document).ready(function ($) {
    $("#rtm-date-range").flatpickr({
        mode: "range",
        maxDate: "today",
        dateFormat: "d-m-Y",
        onChange: function (selectedDates, dateStr, instance) {
            instance.element.value = dateStr.replace('to', '-');
        },
    });

    // Add field of outgoing email setting
    $('body').on('click', '#rtm-mail #add_outgoing_field', function () {
        // random number for semi "unique" box ids
        let box_id = Math.floor(Math.random() * 999);
        let input_html = '<div class="option-email-box" data-boxid="' + box_id + '"><input type="text" name="option_email[]" class="option-email" placeholder="' + rtm_mail_translation.type_address + '" /><select class="outgoing_type" name="outgoing_type[]"><option value="cc">CC</option><option value="bcc">BCC</option><option value="recipient">Recipient</option></select></div>';
        let button_html = '<button type="button" name="remove_outgoing" class="button button-invert-remove remove_outgoing_field" data-boxid="' + box_id + '" style="margin-top: 10px; padding: 0 12px">-</button>';
        $(".outgoing-email").append(input_html);
        $(".outgoing-button").append(button_html);
    });

    // Remove field of outgoing email setting
    $('body').on('click', '#rtm-mail .remove_outgoing_field', function () {
        let box_id = $(this).attr('data-boxid');
        $("[data-boxid='" + box_id + "'").remove();
        $(this).remove();
    });

    // Toggle search filters
    $('body').on('click', '#rtm-mail .filter-box .filter-label-box .filter-label', function () {
        $('#rtm-mail .filter-box .filter-input').slideToggle('fast');
        if ($('#rtm-mail .filter-box .filter-label-box .filter-label').hasClass('filter-label-active')) {
            $('#rtm-mail .filter-box .filter-label-box .filter-label').removeClass('filter-label-active');
        } else {
            $('#rtm-mail .filter-box .filter-label-box .filter-label').addClass('filter-label-active');
        }
    });

    // Close modal
    $('body').on('click', '#rtm-mail .modal-close', function () {
        let log_id = $(this).attr('data-id');
        $('#modal_' + log_id).fadeOut(250);
    });

    // Preview mail modal
    $('body').on('click', '#rtm-mail #preview_mail', function () {
        $('.modal-container').css('height', '60vh');
        $('#modal_preview').fadeIn(250);
    });

    $('body').on('click', '#rtm-mail #add_receiver', function () {
        $('.modal-container').css('height', 'auto');
        $('#add_type').val('receiver');
        $('#modal_add_mail').fadeIn(250);
    });

    $('body').on('click', '#rtm-mail #add_cc', function () {
        $('.modal-container').css('height', 'auto');
        $('#add_type').val('cc');
        $('#modal_add_mail').fadeIn(250);
    });

    $('body').on('click', '#rtm-mail #add_bcc', function () {
        $('.modal-container').css('height', 'auto');
        $('#add_type').val('bcc');
        $('#modal_add_mail').fadeIn(250);
    });

    $('body').on('click', '#rtm-mail #remove_receiver', function () {
        $('.modal-container').css('height', 'auto');
        $('#remove_type').val('receiver');
        $('#remove_mail_list').html('');
        let address_list = $("#edit_receiver").val().split(';');

        if (address_list != null && address_list[0] != null) {
            $.each(address_list, function(index, address) {
                if (address != null && address != '') {
                    let html = '<div class="address_remove_input"><input type="text" name="address_remove" class="address_to_remove" value="'+address+'" disabled /><button type="button" name="remove-receiver" class="button button-invert-remove remove_address">-</button></div>';
                    $('#remove_mail_list').append(html);
                }
            });
        }

        $('#modal_remove_mail').fadeIn(250);
    });

    $('body').on('click', '#rtm-mail #remove_cc', function () {
        $('.modal-container').css('height', 'auto');
        $('#remove_type').val('cc');
        $('#remove_mail_list').html('');
        let address_list = $("#edit_cc").val().split(';');

        if (address_list != null && address_list[0] != null) {
            $.each(address_list, function(index, address) {
                if (address != null && address != '') {
                    let html = '<div class="address_remove_input"><input type="text" name="address_remove" class="address_to_remove" value="'+address+'" disabled /><button type="button" name="remove-receiver" class="button button-invert-remove remove_address">-</button></div>';
                    $('#remove_mail_list').append(html);
                }
            });
        }

        $('#modal_remove_mail').fadeIn(250);
    });

    $('body').on('click', '#rtm-mail #remove_bcc', function () {
        $('.modal-container').css('height', 'auto');
        $('#remove_type').val('bcc');
        $('#remove_mail_list').html('');
        let address_list = $("#edit_bcc").val().split(';');

        if (address_list != null && address_list[0] != null) {
            $.each(address_list, function(index, address) {
                if (address != null && address != '') {
                    let html = '<div class="address_remove_input"><input type="text" name="address_remove" class="address_to_remove" value="'+address+'" disabled /><button type="button" name="remove-receiver" class="button button-invert-remove remove_address">-</button></div>';
                    $('#remove_mail_list').append(html);
                }
            });
        }

        $('#modal_remove_mail').fadeIn(250);
    });

    $('body').on('click', '#rtm-mail .remove_address', function () {
        $(this).parent().remove();
    });

    $('body').on('click', '#rtm-mail #save_added_address', function () {
        let address_type = $("#add_type").val();
        let address = $("#add_mail_address").val();
        if (address_type === 'receiver') {
            if ($("#edit_receiver").val() !== '') {
                $("#edit_receiver").val($("#edit_receiver").val() + ';' + address);
            } else {
                $("#edit_receiver").val(address);
            }
        } else if (address_type === 'cc') {
            if ($("#edit_cc").val() !== '') {
                $("#edit_cc").val($("#edit_cc").val() + ';' + address);
            } else {
                $("#edit_cc").val(address)
            }
        } else if (address_type === 'bcc') {
            if ($("#edit_bcc").val() !== '') {
                $("#edit_bcc").val($("#edit_bcc").val() + ';' + address);
            } else {
                $("#edit_bcc").val(address)
            }
        }
        $("#add_mail_address").val('');
        $('#modal_add_mail').fadeOut(250);
    });

    $('body').on('click', '#rtm-mail #save_removed_address', function () {
        let address_type = $("#remove_type").val();
        let addresses = '';

        $(".address_to_remove").each(function() {
            if (addresses === '') {
                addresses += $(this).val();
            } else {
                addresses += ';'  + $(this).val();
            }
        });

        $("#edit_" + address_type).val(addresses);

        $('#modal_remove_mail').fadeOut(250);
    });

    $('body').on('click', '#rtm-mail #delete_log', function () {
        $('.modal-container').css('height', 'auto');
        $('#modal_delete_log').fadeIn(250);
    });

    $('body').on('click', '#rtm-mail #send_mail', function () {
        $('.modal-container').css('height', 'auto');
        $('#modal_send_log').fadeIn(250);
    });

    $('body').on('click', '#rtm-mail #delete-submit', function () {
        $('.modal-container').css('height', 'auto');
        $('#modal_delete_log_rows').fadeIn(250);
    });

    // Preview overview modal
    $('body').on('click', '#rtm-mail #action-preview', function () {
        $('.modal-container').css({height: '60vh', width: '35vw'});
        $('#rtm-mail .mail-preview').attr("src", "?page=rtm-mail-details&mail_preview=true&log_id="+$(this).attr('data-id'));
        $('#modal_action_preview').fadeIn(250);
    });

    $('body').on('click', '#rtm-mail #action-send', function () {
        $('.modal-container').css({height: 'auto', width: '17vw'});
        $('#send_log_id').val($(this).attr('data-id'));
        $('#modal_log_action_send').fadeIn(250);
    });

    $('body').on('click', '#rtm-mail #action-delete', function () {
        $('.modal-container').css({height: 'auto', width: '17vw'});
        $('#delete_log_id').val($(this).attr('data-id'));
        $('#modal_log_action_delete').fadeIn(250);
    });

    $('body').on('click', '#rtm-mail #send-submit', function () {
        $('.modal-container').css('height', 'auto');
        $('#modal_send_log_rows').fadeIn(250);
    });

    $('body').on('change', '#rtm-mail #cb-select-all-1, #rtm-mail #cb-select-all-2', function () {
        $("#send-submit").prop("disabled", true);
        $("#delete-submit").prop("disabled", true);
        if ($(this).is(':checked')) {
            $("#delete-submit").prop("disabled", false);
            $(".badge").each(function() {
                if ($(this).html() === rtm_mail_translation.status_sent) {
                    $("#send-submit").prop("disabled", true);
                    return false;
                } else if ($(this).html() !== rtm_mail_translation.status_sent) {
                    $("#send-submit").prop("disabled", false);
                }
            });
        }
    });

    $('body').on('change', '#rtm-mail .log-select', function () {
        $("#send-submit").prop("disabled", true);
        $("#delete-submit").prop("disabled", true);
        $(".log-select").each(function() {
            if ($(this).is(':checked')) {
                $("#delete-submit").prop("disabled", false);
                if ($(this).parent().parent().find('.badge').html() === rtm_mail_translation.status_sent) {
                    $("#send-submit").prop("disabled", true);
                    return false;
                } else if ($(this).parent().parent().find('.badge').html() !== rtm_mail_translation.status_sent) {
                    $("#send-submit").prop("disabled", false);
                }
            }
        });
    });

    // Sender options select
    $('body').on('change', '#rtm-mail .sender-preset', function () {
       let option = $(this).val();
       if (option === 'admin_user') {
            $('#admin-preset-list').css('display', 'block');
       } else if (option === 'custom') {
           $('#admin-preset-list').css('display', 'none');
           $('#sender_preset_title').val('');
           $('#sender_preset_address').val('');
       } else {
           $('#admin-preset-list').css('display', 'none');
           let sender_options = option.split(';');
           $('#sender_preset_title').val(sender_options[0]);
           $('#sender_preset_address').val(sender_options[1]);
       }
    });

    $('body').on('change', '#rtm-mail .admin-sender-preset', function () {
        let option = $(this).val();
        let sender_options = option.split(';');
        $('#sender_preset_title').val(sender_options[0]);
        $('#sender_preset_address').val(sender_options[1]);
    });

    $('body').on('click', '#rtm-mail .event-detail-block', function () {
        let target = $(this).parent().find('.event-details-expand');
        $(target).slideToggle();
        $(this).find('.caret__icon').toggleClass('fa-caret-down').toggleClass('fa-caret-left');
    });
})
