<?php
global $log;
$mail_log = $log[0] ?? null;

// Check if the current log is empty
if ($mail_log == null) {
    echo 'No preview found';
} else {
    echo $mail_log['body'];
    $upload = wp_upload_dir();

    if (isset($mail_log['attachments']) && !empty($mail_log['attachments'])) {
?>
    <p style="font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen-Sans, Ubuntu, Cantarell, 'Helvetica Neue', sans-serif;font-weight: bold; color: #000; font-size: 14px; margin-top: 10px; text-decoration:none;"><?php _e('Attachments', 'rtm-mail'); ?></p>
    <div class="attachment-previews" style="display: flex; margin-top: 15px;">
<?php
        foreach ($mail_log['attachments'] as $attachment) {
            $file_type = explode('/', mime_content_type($attachment));
            $upload = wp_upload_dir();
            $file_path = str_replace($upload['basedir'], '', $attachment);
            $file_name = substr($attachment, strrpos($attachment, '/'));
            if ($file_type[0] === 'image') {
?>
                <a href="<?php echo $upload['baseurl'] . $file_path; ?>" target="_blank" class="attachment-preview-item" style="position: relative; width: 150px; height: 150px; border: 2px solid #eeeeee; border-radius: 5px; margin-right: 10px;">
                    <div class="attachment-preview-item-label" style="position: absolute; bottom:0; left: 0; width: 100%; background: rgba(0,0,0, 0.4); border-bottom-left-radius: 5px; border-bottom-right-radius: 5px;">
                        <p style="font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen-Sans, Ubuntu, Cantarell, 'Helvetica Neue', sans-serif;font-weight: bold; color: #fff; font-size: 11px; padding: 5px;"><?php echo $file_name; ?></p>
                    </div>
                    <img src="<?php echo $upload['baseurl'] . $file_path; ?>" alt="mail-attachment" style="width: 100%; height: 100%;" />
                </a>
<?php
            } else {
?>
                <a href="<?php echo $upload['baseurl'] . $file_path; ?>" target="_blank" class="attachment-preview-item" style="position: relative; width: 150px; height: 150px; border: 2px solid #eeeeee; border-radius: 5px; margin-right: 10px;">
                    <div class="attachment-preview-item-label" style="position: absolute; bottom:0; left: 0; width: 100%; background: rgba(0,0,0, 0.4); border-bottom-left-radius: 5px; border-bottom-right-radius: 5px;">
                        <p style="font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen-Sans, Ubuntu, Cantarell, 'Helvetica Neue', sans-serif;font-weight: bold; color: #fff; font-size: 11px; padding: 5px;"><?php echo $file_name; ?></p>
                    </div>
                    <p style="font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen-Sans, Ubuntu, Cantarell, 'Helvetica Neue', sans-serif;font-weight: bold; color: #000; font-size: 14px; padding: 10px; text-decoration:none; font-style: normal; text-align: center"><?php echo strtoupper(pathinfo($attachment, PATHINFO_EXTENSION)); ?> FILE</p>
                </a>
<?php
            }
        }
?>
        </div>
<?php
    }

}
?>