<?php
/**
 * Settings page
 */

// Get current settings options
$settings = get_option('rtm_mail_settings');
$send_mails = $settings['send_mails'] ?? false;
$edit_mails = $settings['edit_mails'] ?? false;
$sender_options = $settings['sender_options'] ?? null;
?>
<div class="wrap" id="rtm-mail">
    <div class="rtm-mail-header">
        <div class="rtm-mail-header-title">RTM Mail</div>
    </div>

    <div class="rtm-mail-page-content">
        <div class="rtm-page-info">
            <h2 class="heading rtm-heading"><?php echo __('Settings', 'rtm-mail'); ?></h2>
            <p class="rtm-heading-description"><?php echo __('On this page you can change the settings of the RTM Mail Catcher. Be sure to look through all the settings this plugin has to offer.', 'rtm-mail'); ?></p>
        </div>
        <hr>
        <div class="rtm-mail-page-content">
            <form id="rtm-mail-settings" action="" method="post">
                <div class="settings-block">
                    <div class="settings-block-option">
                        <p class="option-label"><?php echo __('Send emails', 'rtm-mail'); ?></p>
                        <p class="option-description"><?php echo __('If you enable this, all emails will be send after they have been caught by the plugin. If this is disabled the email will not be send. You can still send an email on the detail page.', 'rtm-mail'); ?></p>
                    </div>
                    <div class="settings-block-input">
                        <label class="option-switch">
                            <input type="checkbox" class="option-checkbox"
                                   name="send_mails" <?php echo checked(1, filter_var($send_mails, FILTER_VALIDATE_BOOLEAN), false); ?> />
                            <span class="option-slider">
                                <span class="option-slider-on"><?php echo __('ON', 'rtm-mail'); ?></span>
                                <span class="option-slider-off"><?php echo __('OFF', 'rtm-mail'); ?></span>
                            </span>
                        </label>
                    </div>
                </div>
                <div class="settings-block">
                    <div class="settings-block-option">
                        <p class="option-label"><?php echo __('Edit sent emails', 'rtm-mail'); ?></p>
                        <p class="option-description"><?php echo __('If you want you can choose if anyone can edit emails that have already been sent, if this is disabled no one can edit the email when it has been sent by someone.', 'rtm-mail'); ?></p>
                    </div>
                    <div class="settings-block-input">
                        <label class="option-switch">
                            <input type="checkbox" class="option-checkbox"
                                   name="edit_mails" <?php echo checked(1, filter_var($edit_mails, FILTER_VALIDATE_BOOLEAN), false); ?> />
                            <span class="option-slider">
                                <span class="option-slider-on"><?php echo __('ON', 'rtm-mail'); ?></span>
                                <span class="option-slider-off"><?php echo __('OFF', 'rtm-mail'); ?></span>
                            </span>
                        </label>
                    </div>
                </div>
                <div class="settings-block">
                    <div class="settings-block-option">
                        <p class="option-label"><?php echo __('Sender options', 'rtm-mail'); ?></p>
                        <p class="option-description"><?php echo __('If you want you can set default sender options, this includes the mail title and the sender address. If you leave these fields blank the plugin will use the site name as mail title and the admin address as sender address.', 'rtm-mail'); ?></p>
                    </div>
                    <div class="settings-block-input">
                        <div class="sender-preset-input" style="display: block;">
                            <div class="sender-input-box" style="margin-bottom: 15px;">
                                <p class="edit-input-label"><?php echo __('Mail title', 'rtm-mail'); ?></p>
                                <input type="text" name="sender_options[title]" id="sender_preset_title"
                                       value="<?php echo ($sender_options != null && !empty($sender_options['title'])) ? $sender_options['title'] : ''; ?>"
                                       class="edit-input-text edit-preset-text" />
                            </div>
                            <div class="sender-input-box">
                                <p class="edit-input-label"><?php echo __('Sender address', 'rtm-mail'); ?></p>
                                <input type="text" name="sender_options[address]" id="sender_preset_address"
                                       value="<?php echo ($sender_options != null && !empty($sender_options['address'])) ? $sender_options['address'] : ''; ?>"
                                       class="edit-input-text edit-preset-text" />
                            </div>
                        </div>
                    </div>
                </div>
                <div class="settings-block">
                    <div class="settings-block-option">
                        <p class="option-label"><?php echo __('Address for outgoing emails', 'rtm-mail'); ?></p>
                        <p class="option-description"><?php echo __('You can add an adress to the CC/BCC/Recipient for every outgoing email, click on the "+" to add more addresses.', 'rtm-mail'); ?></p>
                    </div>
                    <div class="settings-block-input">
                        <div class="option-outgoing outgoing-email">
                            <?php
                            if (isset($settings['addresses']) && !empty($settings['addresses'])) {
                                foreach ($settings['addresses'] as $index => $address) {
                                    ?>
                                    <div class="option-email-box" data-boxid="<?php echo $index; ?>">
                                        <input type="text" name="option_email[]" class="option-email"
                                               placeholder="<?php echo __('Type an address', 'rtm-mail'); ?>"
                                               value="<?php echo $address['address']; ?>"/>
                                        <select class="outgoing_type" name="outgoing_type[]">
                                            <option value="cc" <?php echo $address['type'] == 'cc' ? ' selected="selected"' : ''; ?>>
                                                CC
                                            </option>
                                            <option value="bcc" <?php echo $address['type'] == 'bcc' ? ' selected="selected"' : ''; ?>>
                                                BCC
                                            </option>
                                            <option value="recipient" <?php echo $address['type'] == 'recipient' ? ' selected="selected"' : ''; ?>>
                                                Recipient
                                            </option>
                                        </select>
                                    </div>
                                    <?php
                                }
                            } else {
                                ?>
                                <div class="option-email-box" data-boxid="1">
                                    <input type="text" name="option_email[]" class="option-email"
                                           placeholder="<?php echo __('Type an address', 'rtm-mail'); ?>"/>
                                    <select class="outgoing_type" name="outgoing_type[]">
                                        <option value="cc">CC</option>
                                        <option value="bcc">BCC</option>
                                        <option value="recipient">Recipient</option>
                                    </select>
                                </div>
                                <?php
                            }
                            ?>
                        </div>
                        <div class="option-outgoing outgoing-button">
                            <button type="button" id="add_outgoing_field" name="add_outgoing"
                                    class="button button-invert">+
                            </button>
                            <?php
                            if (isset($settings['addresses'])) {
                                foreach ($settings['addresses'] as $index => $address) {
                                    if ($index != 0) {
                                        ?>
                                        <button type="button" name="remove_outgoing"
                                                class="button button-invert-remove remove_outgoing_field"
                                                data-boxid="<?php echo $index; ?>"
                                                style="margin-top: 10px; padding: 0 12px">-
                                        </button>
                                        <?php
                                    }
                                }
                            }
                            ?>
                        </div>
                    </div>
                </div>
                <input type="hidden" name="_wpnonce"
                       value="<?php echo esc_attr(wp_create_nonce('rtm_mail_save_settings')); ?>"/>
                <?php submit_button(__('Save settings', 'rtm-mail'), '', 'save_settings', false, ['id' => 'save-settings']); ?>
            </form>
        </div>
    </div>
</div>
