<?php
/**
 * Plugin Name: RTM Mail
 * Version: 0.3.1
 * Requires at least: 5.0
 * Requires PHP: 7.2
 * Plugin URI: https://www.rtmbusiness.nl/
 * Description: Catches every mail sent with the <code>wp_mail()</code> function and saves it to the database.
 * Author: Nick van Duijn
 * Author URI: https://www.rtmbusiness.nl/
 * Text Domain: rtm-mail
 */

// When the file is called directly exit the code
if (!defined('ABSPATH')) {
    exit;
}

// Define the plugin path when it isn't     defined yet
if (!defined('RTM_MAIL_PLUGIN_PATH')) {
    define('RTM_MAIL_PLUGIN_PATH', plugin_dir_url(__FILE__));
}

// Define the plugin version (Don't change this, it's needed for the migration check)
if (!defined('RTM_MAIL_VERSION')) {
    define('RTM_MAIL_VERSION', '0.0.7');
}

// Define the plugin database table prefix
if (!defined('RTM_MAIL_TABLE_PREFIX')) {
    define('RTM_MAIL_TABLE_PREFIX', $GLOBALS['wpdb']->prefix . 'rtm_mail_');
}

// Require the autoloader
if (!class_exists("RtmMail\\Core")) {
    require_once plugin_dir_path(__FILE__) . 'vendor/autoload.php';
}
// Load the core class
$core = new RtmMail\Core();
// register activation and deactivation hook
register_activation_hook(__FILE__, [$core, 'activate']);
register_deactivation_hook(__FILE__, [$core, 'deactivate']);

// Instantiate Wonolog
Inpsyde\Wonolog\bootstrap();