<?php
/**
 * Events page
 */

use RtmMail\EventsTable;

$events_table = new EventsTable();
$events_table->prepare_items();
?>

<div class="wrap" id="rtm-mail">
    <div class="rtm-mail-header">
        <div class="rtm-mail-header-title">RTM Mail</div>
    </div>

    <div class="rtm-mail-page-content">
        <div class="rtm-page-info">
            <h2 class="heading rtm-heading"><?php echo __('Events', 'rtm-mail'); ?></h2>
            <p class="rtm-heading-description"><?php echo __('On this page you can check every event that happened in the RTM Mail Plugin. Here you can see what logs were sent, edited or deleted. You can also find emails that failed to sent and the error.', 'rtm-mail'); ?></p>
        </div>
        <hr>
        <div class="rtm-mail-page-events">
            <form method="get">
                <input type="hidden" name="page" value="rtm-mail-events"/>
                <div class="table-top-box">
                    <div class="date-box">
                        <input type="text" id="rtm-date-range" name="date"
                               placeholder="<?php echo __('Select a date range', 'rtm-mail'); ?>"/>
                        <?php submit_button(__('Filter', 'rtm-mail'), '', 'filter-date-range', false, ['id' => 'filter-date-range']); ?>
                    </div>
                    <?php $events_table->search_box(__('Search', 'rtm-mail'), 'search_id'); ?>
                </div>
                <?php $events_table->display(); ?>
            </form>
        </div>
    </div>
</div>
