<?php
global $log;
$mail_log = $log[0] ?? null;

// Check if the current log is empty
if ($mail_log == null) {
    echo '<div class="notice notice-error"> ';
    echo '<p><strong>RTM Mail: </strong>';
    echo __('No log was found with this log_id', 'rtm-mail');
    echo '</p>';
    echo '</div>';
} else {
    ?>
    <div class="wrap" id="rtm-mail">
        <div class="rtm-mail-header">
            <div class="rtm-mail-header-title">RTM Mail</div>
        </div>

        <div class="rtm-mail-page-content">
            <div class="rtm-page-info">
                <h2 class="heading rtm-heading"><?php echo __('Details', 'rtm-mail'); ?></h2>
                <p class="rtm-heading-description"><?php echo __('On this page you will find the details about your selected email. You can also edit certain fields and send the email if it wasn\'t already sent. Always save the mail first before sending.', 'rtm-mail'); ?></p>
            </div>
            <hr>
            <div class="rtm-mail-page-details">
                <div class="details-edit-box">
                    <form method="post">
                        <input type="hidden" name="action" value="edit"/>
                        <input type="hidden" name="log_id" value="<?php echo $mail_log['id']; ?>"/>
                        <input type="hidden" name="_wpnonce"
                               value="<?php echo esc_attr(wp_create_nonce('rtm_mail_edit_log')); ?>"/>
                        <h2 class="heading rtm-heading"><?php echo __('Edit', 'rtm-mail'); ?></h2>
                        <div class="details-edit-input">
                            <div class="edit-input">
                                <p class="edit-input-label"><?php echo __('Receiver', 'rtm-mail'); ?></p>
                                <input type="text" name="receiver" id="edit_receiver"
                                       value="<?php echo !empty($mail_log['receiver']) ? implode(';', $mail_log['receiver']) : ''; ?>"
                                       class="edit-input-text" <?php echo $mail_log['status'] == 'sent' ? 'disabled="true"' : '' ?> />
                            </div>
                            <div class="edit-buttons">
                                <?php
                                if ($mail_log['status'] != 'sent') {
                                    ?>
                                    <button type="button" name="add-receiver" id="add_receiver"
                                            class="button button-invert">+
                                    </button>
                                    <button type="button" name="remove-receiver" id="remove_receiver"
                                            class="button button-invert-remove">-
                                    </button>
                                    <?php
                                }
                                ?>
                            </div>
                        </div>
                        <div class="details-edit-input">
                            <div class="edit-input">
                                <p class="edit-input-label"><?php echo __('CC', 'rtm-mail'); ?></p>
                                <input type="text" name="cc" id="edit_cc"
                                       value="<?php echo !empty($mail_log['cc']) ? implode(';', $mail_log['cc']) : ''; ?>"
                                       class="edit-input-text" <?php echo $mail_log['status'] == 'sent' ? 'disabled="true"' : '' ?> />
                            </div>
                            <div class="edit-buttons">
                                <?php
                                if ($mail_log['status'] != 'sent') {
                                    ?>
                                    <button type="button" name="add-cc" id="add_cc" class="button button-invert">+
                                    </button>
                                    <button type="button" name="remove-cc" id="remove_cc"
                                            class="button button-invert-remove">
                                        -
                                    </button>
                                    <?php
                                }
                                ?>
                            </div>
                        </div>
                        <div class="details-edit-input">
                            <div class="edit-input">
                                <p class="edit-input-label"><?php echo __('BCC', 'rtm-mail'); ?></p>
                                <input type="text" name="bcc" id="edit_bcc"
                                       value="<?php echo !empty($mail_log['bcc']) ? implode(';', $mail_log['bcc']) : ''; ?>"
                                       class="edit-input-text" <?php echo $mail_log['status'] == 'sent' ? 'disabled="true"' : '' ?> />
                            </div>
                            <div class="edit-buttons">
                                <?php
                                if ($mail_log['status'] != 'sent') {
                                    ?>
                                    <button type="button" name="add-bcc" id="add_bcc" class="button button-invert">+
                                    </button>
                                    <button type="button" name="remove-bcc" id="remove_bcc"
                                            class="button button-invert-remove">
                                        -
                                    </button>
                                    <?php
                                }
                                ?>
                            </div>
                        </div>
                        <div class="details-edit-input">
                            <div class="edit-input">
                                <p class="edit-input-label"><?php echo __('Subject', 'rtm-mail'); ?></p>
                                <input type="text" name="subject" id="edit_subject"
                                       value="<?php echo $mail_log['subject']; ?>"
                                       class="edit-input-text" <?php echo $mail_log['status'] == 'sent' ? 'disabled="true"' : '' ?> />
                            </div>
                        </div>
                        <div class="details-edit-input">
                            <div class="edit-input">
                                <p class="edit-input-label"><?php echo __('Body (content)', 'rtm-mail'); ?></p>
                                <textarea name="body" id="edit_body"
                                          class="edit-input-text edit-input-body" <?php echo $mail_log['status'] == 'sent' ? 'disabled="true"' : '' ?>><?php echo $mail_log['body']; ?></textarea>
                            </div>
                        </div>
                        <?php $mail_log['status'] != 'sent' ? submit_button(__('Save mail', 'rtm-mail'), '', 'save_mail_log', false, ['id' => 'save-mail-log']) : ''; ?>
                    </form>
                </div>
                <div class="details-detail-box">
                    <h2 class="heading rtm-heading"><?php echo __('Details', 'rtm-mail'); ?></h2>
                    <div class="detail-status">
                        <div class="detail-status-box">
                            <p class="edit-input-label"><?php echo __('Status', 'rtm-mail'); ?></p>
                            <?php
                            $label = __('Caught', 'rtm-mail');
                            switch ($mail_log['status']) {
                                case 'caught':
                                    $label = __('Caught', 'rtm-mail');
                                    break;
                                case'sent':
                                    $label = __('Sent', 'rtm-mail');
                                    break;
                                case 'failed':
                                    $label = __('Failed', 'rtm-mail');
                                    break;
                            }
                            echo '<p><span class="badge badge-' . $mail_log['status'] . '">' . $label . '</span></p>';
                            ?>
                        </div>
                        <div class="detail-status-box">
                            <p class="edit-input-label"><?php echo __('Sender', 'rtm-mail'); ?></p>
                            <p><?php echo $mail_log['sender']; ?></p>
                        </div>
                    </div>
                    <div class="detail-dates">
                        <div class="detail-date-box">
                            <p class="edit-input-label"><?php echo __('Creation date', 'rtm-mail'); ?></p>
                            <p><?php echo date_format(date_create($mail_log['created']), 'd-m-Y H:i'); ?></p>
                        </div>
                        <div class="detail-date-box">
                            <p class="edit-input-label"><?php echo __('Updated on', 'rtm-mail'); ?></p>
                            <p><?php echo !empty($mail_log['updated']) ? date_format(date_create($mail_log['updated']), 'd-m-Y H:i') : __('Not updated yet...', 'rtm-mail'); ?></p>
                        </div>
                        <div class="detail-date-box">
                            <p class="edit-input-label"><?php echo __('Date sent', 'rtm-mail'); ?></p>
                            <p><?php echo !empty($mail_log['sent']) ? date_format(date_create($mail_log['sent']), 'd-m-Y H:i') : __('Not sent yet...', 'rtm-mail'); ?></p>

                        </div>
                    </div>
                    <div class="detail-attachments">
                        <p class="edit-input-label"><?php echo __('Attachments', 'rtm-mail'); ?></p>
                        <div class="attachments-box">
                            <?php
                            if (isset($mail_log['attachments'])) {
                                foreach ($mail_log['attachments'] as $attachment) {
                                    $upload = wp_upload_dir();
                                    $file_path = str_replace($upload['basedir'], '', $attachment);
                                    $file_name = substr($attachment, strrpos($attachment, '/'));
                                    ?>
                                    <a style="text-decoration: none!important;"
                                       href="<?php echo $upload['baseurl'] . $file_path; ?>" target="_blank">
                                        <div class="attachment-item" data-file="<?php echo $file_name; ?>">
                                            <div class="attachment-item-detail">
                                                <p class="edit-input-label"><?php echo __('File name', 'rtm-mail'); ?></p>
                                                <p class="attachment-name"><?php echo $file_name; ?></p>
                                            </div>
                                            <div class="attachment-item-detail">
                                                <p class="edit-input-label"><?php echo __('File type', 'rtm-mail'); ?></p>
                                                <p class="extension-name"><?php echo mime_content_type($attachment); ?></p>
                                            </div>
                                        </div>
                                    </a>
                                    <?php
                                }
                            } else {
                                echo __('No attachments to this mail...', 'rtm-mail');
                            }
                            ?>
                        </div>
                    </div>
                    <div class="detail-buttons">
                        <input type="button" name="preview-mail" id="preview_mail" class="button"
                               value="<?php echo __('Preview', 'rtm-mail'); ?>"/>
                        <input type="button" name="delete_log" id="delete_log" class="button button-delete"
                               value="<?php echo __('Delete', 'rtm-mail'); ?>"/>
                        <?php
                        if ($mail_log['status'] != 'sent') {
                            echo '<input type="button" name="send_mail" id="send_mail" class="button button-success" value="' . __('Send Email', 'rtm-mail') . '" />';
                        }
                        ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal preview-modal" id="modal_preview">
            <div class="modal-container">
                <div class="modal-header">
                    <h3><?php echo __('Preview', 'rtm-mail'); ?></h3>
                    <span class="modal-close" data-id="preview">x</span>
                </div>
                <hr>
                <div class="modal-content">
                    <iframe src="?page=rtm-mail-details&mail_preview=true&log_id=<?php echo $mail_log['id']; ?>"
                            class="mail-preview"></iframe>
                </div>
            </div>
        </div>
        <div class="modal add-modal" id="modal_add_mail">
            <div class="modal-container">
                <div class="modal-header">
                    <h3><?php echo __('Add address', 'rtm-mail'); ?></h3>
                    <span class="modal-close" data-id="add_mail">x</span>
                </div>
                <hr>
                <div class="modal-content">
                    <input type="hidden" name="type" id="add_type" value="receiver"/>
                    <p class="edit-input-label"><?php echo __('Address', 'rtm-mail'); ?>:</p>
                    <input type="text" name="mail_address" id="add_mail_address" class="edit-input-text"
                           placeholder="Type an address..."/>
                    <button type="button" class="button" id="save_added_address"
                            style="margin-top: 10px;"><?php echo __('Save', 'rtm-mail'); ?></button>
                </div>
            </div>
        </div>
        <div class="modal remove-modal" id="modal_remove_mail">
            <div class="modal-container">
                <div class="modal-header">
                    <h3><?php echo __('Remove address', 'rtm-mail'); ?></h3>
                    <span class="modal-close" data-id="remove_mail">x</span>
                </div>
                <hr>
                <div class="modal-content">
                    <input type="hidden" name="type" id="remove_type" value="receiver"/>
                    <div id="remove_mail_list">
                    </div>
                    <button type="button" class="button"
                            id="save_removed_address"><?php echo __('Save', 'rtm-mail'); ?></button>
                </div>
            </div>
        </div>
        <div class="modal delete-log-modal" id="modal_delete_log">
            <div class="modal-container">
                <div class="modal-header" style="display: block!important;">
                    <span class="modal-close" data-id="delete_log">x</span>
                </div>
                <div class="modal-content">
                    <form method="post">
                        <input type="hidden" name="_wpnonce"
                               value="<?php echo esc_attr(wp_create_nonce('rtm_mail_delete_log')); ?>"/>
                        <input type="hidden" name="action" value="delete_log"/>
                        <input type="hidden" name="log_id" value="<?php echo $mail_log['id']; ?>"/>
                        <p>
                            <strong><?php echo __('Are you sure you want to delete this mail log?', 'rtm-mail'); ?></strong>
                        </p>
                        <button type="submit" name="delete_log" class="button button-delete"
                                id="confirm_delete_log"><?php echo __('Delete', 'rtm-mail'); ?></button>
                    </form>
                </div>
            </div>
        </div>
        <div class="modal delete-log-modal" id="modal_send_log">
            <div class="modal-container">
                <div class="modal-header" style="display: block!important;">
                    <span class="modal-close" data-id="send_log">x</span>
                </div>
                <div class="modal-content">
                    <form method="post">
                        <input type="hidden" name="_wpnonce"
                               value="<?php echo esc_attr(wp_create_nonce('rtm_mail_send_log')); ?>"/>
                        <input type="hidden" name="action" value="send_log"/>
                        <input type="hidden" name="log_id" value="<?php echo $mail_log['id']; ?>"/>
                        <p><strong><?php echo __('Are you sure you want to send this email?', 'rtm-mail'); ?></strong>
                        </p>
                        <button type="submit" name="send_log" class="button button-success"
                                id="confirm_send_log"><?php echo __('Send', 'rtm-mail'); ?></button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <?php
}