<?php

namespace RtmMail;

use RtmMail\Helpers\LogHelper;

/**
 * Overview - handles every user interaction for the overview page
 */
class Overview extends AbstractPage
{
    protected $slug = 'overview';

    public function __construct()
    {
        parent::__construct();
    }

    /**
     * handle_requests - every page can handle their requests (post/get)
     */
    public function handle_requests()
    {
        if ($this->page_check()) {

            if (isset($_POST['action'])) {
                if ($_POST['action'] == 'send_log') {
                    if (wp_verify_nonce($_POST['_wpnonce'], 'rtm_mail_action_send')) {
                        if (isset($_POST['log_id']) && !empty($_POST['log_id'])) {
                            if (isset($_POST['send_log'])) {
                                // Send the email with the given log id
                                if (Catcher::send_mail($_POST['log_id']) == 'success') {
                                    wp_redirect(get_admin_url() . 'admin.php?page=rtm-mail-details&log_id=' . $_POST['log_id'] . '&sent_successful=true');
                                } else {
                                    wp_redirect(get_admin_url() . 'admin.php?page=rtm-mail-details&log_id=' . $_POST['log_id'] . '&sent_failed=true');
                                }
                                exit();
                            }
                        }
                    }
                } else if ($_POST['action'] == 'delete_log') {
                    if (wp_verify_nonce($_POST['_wpnonce'], 'rtm_mail_action_delete')) {
                        if (isset($_POST['log_id']) && !empty($_POST['log_id'])) {
                            if (isset($_POST['delete_log'])) {
                                // Delete the log
                                LogHelper::delete(['id' => $_POST['log_id']]);
                                // Redirect to overview
                                wp_redirect(get_admin_url() . 'admin.php?page=rtm-mail-overview&delete_successful=true');
                                exit();
                            }
                        }
                    }
                } else if ($_POST['action'] == 'test_mail') {
                    wp_mail(get_option('admin_email'), 'This is a sample subject', '<h1>This is a test</h1><p>This is just a test mail to see if everything is working OK</p>', 'Content-Type:text/html', []);
                    add_action('admin_notices', function () {
                        echo '<div class="notice notice-success"> ';
                        echo '<p><strong>RTM Mail: </strong>';
                        echo __('A test email was sent to the admin email!', 'rtm-mail');
                        echo '</p>';
                        echo '</div>';
                    });
                }
            }

            // Check if the user wants to delete logs
            if (isset($_GET['action'])) {
                if (isset($_GET['delete_log_rows'])) {
                    // Verify the delete nonce
                    if (wp_verify_nonce($_GET['_wpnonce_delete'], 'rtm_mail_delete_log_rows')) {
                        // Delete every selected id
                        if (isset($_GET['id'])) {
                            foreach ($_GET['id'] as $id) {
                                if (!empty($id)) {
                                    // delete by id
                                    LogHelper::delete(['id' => $id]);
                                }
                            }
                            // Display notification
                            add_action('admin_notices', function () {
                                echo '<div class="notice notice-success"> ';
                                echo '<p><strong>RTM Mail: </strong>';
                                echo __('Row(s) successfully deleted', 'rtm-mail');
                                echo '</p>';
                                echo '</div>';
                            });
                        }
                    }
                } else if (isset($_GET['send_log_rows'])) {
                    // Verify the sending nonce
                    if (wp_verify_nonce($_GET['_wpnonce_send'], 'rtm_mail_send_log_rows')) {
                        if (isset($_GET['id'])) {
                            foreach ($_GET['id'] as $id) {
                                if (!empty($id)) {
                                    $mail_sent = Catcher::send_mail($id);
                                    if ($mail_sent != 'success') {
                                        // Display error notification
                                        echo '<div class="notice notice-error"> ';
                                        echo '<p><strong>RTM Mail: </strong>';
                                        printf(__('Error sending email log: #%1$s (%2$s)', 'rtm-mail'), $id, $mail_sent);
                                        echo '</p>';
                                        echo '</div>';
                                    }
                                }
                            }
                            // Display notification
                            add_action('admin_notices', function () {
                                echo '<div class="notice notice-success"> ';
                                echo '<p><strong>RTM Mail: </strong>';
                                echo __('Selected row(s) were sent', 'rtm-mail');
                                echo '</p>';
                                echo '</div>';
                            });
                        }
                    }
                }
            } else if (isset($_GET['delete_successful'])) {
                // If deletion was successful display notification
                add_action('admin_notices', function () {
                    echo '<div class="notice notice-success"> ';
                    echo '<p><strong>RTM Mail: </strong>';
                    echo __('Log successfully deleted', 'rtm-mail');
                    echo '</p>';
                    echo '</div>';
                });
            }
        }
    }
}