<?php
/**
 * Overview page
 */

use RtmMail\LogsTable;

$log_table = new LogsTable();
$log_table->prepare_items();
?>


<div class="wrap" id="rtm-mail">
    <div class="rtm-mail-header">
        <div class="rtm-mail-header-title">RTM Mail</div>
    </div>

    <div class="rtm-mail-page-content">
        <div class="rtm-page-info">
            <h2 class="heading rtm-heading"><?php echo __('Overview', 'rtm-mail'); ?></h2>
            <p class="rtm-heading-description"><?php echo __('On this page you will find a list of all sent emails from the website. Here you can choose an email to preview, send, edit or delete. You can also search on subject, receiver and look for emails between certain dates.', 'rtm-mail'); ?></p>
        </div>
        <hr>
        <div class="rtm-mail-page-overview">
            <form method="get">
                <input type="hidden" name="page" value="rtm-mail-overview"/>
                <div class="table-top-box">
                    <div class="date-box">
                        <input type="text" id="rtm-date-range" name="date"
                               placeholder="<?php echo __('Select a date range', 'rtm-mail'); ?>"/>
                        <?php submit_button(__('Filter', 'rtm-mail'), '', 'filter-date-range', false, ['id' => 'filter-date-range']); ?>
                    </div>
                    <?php $log_table->search_box(__('Search', 'rtm-mail'), 'search_id'); ?>
                </div>
                <?php $log_table->display(); ?>
                <div class="modal delete-log-modal" id="modal_delete_log_rows">
                    <div class="modal-container">
                        <div class="modal-header" style="display: block!important;">
                            <span class="modal-close" data-id="delete_log_rows">x</span>
                        </div>
                        <div class="modal-content">
                            <input type="hidden" name="_wpnonce"
                                   value="<?php echo esc_attr(wp_create_nonce('rtm_mail_delete_log_rows')); ?>"/>
                            <input type="hidden" name="action" value="delete_log_rows"/>
                            <p>
                                <strong><?php echo __('Are you sure you want to delete the selected mail log(s)?', 'rtm-mail'); ?></strong>
                            </p>
                            <button type="submit" name="delete_log_rows" class="button button-delete"
                                    id="confirm_delete_log_rows"><?php echo __('Delete', 'rtm-mail'); ?></button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
