<?php

namespace RtmMail;

/**
 * Settings - handles every user interaction for the settings page
 */
class Settings extends AbstractPage
{
    protected $slug = 'settings';

    public function __construct()
    {
        parent::__construct();
    }

    /**
     * handle_requests - every page can handle their requests (post/get)
     */
    public function handle_requests()
    {
        // Check if the user is on the settings page
        if ($this->page_check()) {
            // Check for save settings post request
            if (isset($_POST['save_settings'])) {
                // Verify if the post is from the right source
                if (wp_verify_nonce($_POST['_wpnonce'], 'rtm_mail_save_settings')) {
                    $addresses = [];
                    $outgoing_mails = $_POST['option_email'];
                    $outgoing_types = $_POST['outgoing_type'];
                    // Check if send mails is enabled
                    $send_mails = isset($_POST['send_mails']) ? filter_var($_POST['send_mails'], FILTER_VALIDATE_BOOLEAN) : false;

                    // Loop through every outgoing mail and check if an address is filled in
                    foreach ($outgoing_mails as $index => $address) {
                        if (!empty($address)) {
                            // Add to addresses array
                            $addresses[] = [
                                'address' => $address,
                                'type' => $outgoing_types[$index]
                            ];
                        }
                    }
                    // Save to option table
                    update_option('rtm_mail_settings', [
                        'send_mails' => $send_mails,
                        'addresses' => $addresses,
                    ]);
                    echo '<div class="notice notice-success"> ';
                    echo '<p><strong>RTM Mail: </strong>';
                    echo __('Settings successfully saved!', 'rtm-mail');
                    echo '</p>';
                    echo '</div>';
                } else {
                    // Quit when invalid nonce
                    echo '<div class="notice notice-error"> ';
                    echo '<p><strong>RTM Mail: </strong>';
                    echo __('Invalide nonce!', 'rtm-mail');
                    echo '</p>';
                    echo '</div>';
                }
            }
        }
    }
}