<?php

namespace RtmMail;

use RtmMail\Helpers\LogHelper;

/**
 * Overview - handles every user interaction for the overview page
 */
class Overview extends AbstractPage
{
    protected $slug = 'overview';

    public function __construct()
    {
        parent::__construct();
    }

    /**
     * handle_requests - every page can handle their requests (post/get)
     */
    public function handle_requests()
    {
        if ($this->page_check()) {
            // Check if the user wants to delete logs
            if (isset($_GET['action']) && $_GET['action'] == 'delete_log_rows') {
                // Verify the delete nonce
                if (wp_verify_nonce($_GET['_wpnonce'], 'rtm_mail_delete_log_rows')) {
                    // Delete every selected id
                    if (isset($_GET['id'])) {
                        foreach ($_GET['id'] as $id) {
                            if (!empty($id)) {
                                // delete by id
                                LogHelper::delete(['id' => $id]);
                            }
                        }
                        // Display notification
                        add_action('admin_notices', function () {
                            echo '<div class="notice notice-success"> ';
                            echo '<p><strong>RTM Mail: </strong>';
                            echo __('Row(s) successfully deleted', 'rtm-mail');
                            echo '</p>';
                            echo '</div>';
                        });
                    }
                }
            } else if (isset($_GET['delete_successful'])) {
                // If deletion was successful display notification
                add_action('admin_notices', function () {
                    echo '<div class="notice notice-success"> ';
                    echo '<p><strong>RTM Mail: </strong>';
                    echo __('Log successfully deleted', 'rtm-mail');
                    echo '</p>';
                    echo '</div>';
                });
            }
        }
    }
}