<?php

/*
 * This file is part of twig-cache-extension.
 *
 * (c) Alexander <iam.asm89@gmail.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace RtmMailVendor\Dependencies\Twig\CacheExtension;

/**
 * Cache strategy interface.
 *
 * @author Alexander <iam.asm89@gmail.com>
 */
interface CacheStrategyInterface
{
    /**
     * Fetch the block for a given key.
     *
     * @param mixed $key
     *
     * @return mixed
     */
    public function fetchBlock($key);

    /**
     * Generate a key for the value.
     *
     * @param string $annotation
     * @param mixed  $value
     *
     * @return mixed
     */
    public function generateKey($annotation, $value);

    /**
     * Save the contents of a rendered block.
     *
     * @param mixed  $key
     * @param string $block
     *
     * @return mixed
     */
    public function saveBlock($key, $block);
}
