<?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace RtmMailVendor\Dependencies\Symfony\Component\Serializer\Context\Normalizer;

use RtmMailVendor\Dependencies\Symfony\Component\PropertyAccess\Exception\InvalidPropertyPathException;
use RtmMailVendor\Dependencies\Symfony\Component\PropertyAccess\PropertyPath;
use RtmMailVendor\Dependencies\Symfony\Component\Serializer\Context\ContextBuilderInterface;
use RtmMailVendor\Dependencies\Symfony\Component\Serializer\Context\ContextBuilderTrait;
use RtmMailVendor\Dependencies\Symfony\Component\Serializer\Exception\InvalidArgumentException;
use RtmMailVendor\Dependencies\Symfony\Component\Serializer\Normalizer\UnwrappingDenormalizer;

/**
 * A helper providing autocompletion for available UnwrappingDenormalizer options.
 *
 * @author Mathias Arlaud <mathias.arlaud@gmail.com>
 */
final class UnwrappingDenormalizerContextBuilder implements ContextBuilderInterface
{
    use ContextBuilderTrait;

    /**
     * Configures the path of wrapped data during denormalization.
     *
     * Eg: [foo].bar[bar]
     *
     * @see https://symfony.com/doc/current/components/property_access.html
     *
     * @throws InvalidArgumentException
     */
    public function withUnwrapPath(?string $unwrapPath): static
    {
        if (null === $unwrapPath) {
            return $this->with(UnwrappingDenormalizer::UNWRAP_PATH, null);
        }

        try {
            new PropertyPath($unwrapPath);
        } catch (InvalidPropertyPathException $e) {
            throw new InvalidArgumentException('The "%s" property path is not valid.', previous: $e);
        }

        return $this->with(UnwrappingDenormalizer::UNWRAP_PATH, $unwrapPath);
    }
}
