<?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace RtmMailVendor\Dependencies\Symfony\Component\Serializer\Context\Normalizer;

use RtmMailVendor\Dependencies\Symfony\Component\Serializer\Context\ContextBuilderInterface;
use RtmMailVendor\Dependencies\Symfony\Component\Serializer\Context\ContextBuilderTrait;
use RtmMailVendor\Dependencies\Symfony\Component\Serializer\Normalizer\DateIntervalNormalizer;

/**
 * A helper providing autocompletion for available DateIntervalNormalizer options.
 *
 * @author Mathias Arlaud <mathias.arlaud@gmail.com>
 */
final class DateIntervalNormalizerContextBuilder implements ContextBuilderInterface
{
    use ContextBuilderTrait;

    /**
     * Configures the format of the interval.
     *
     * @see https://php.net/manual/en/dateinterval.format.php
     */
    public function withFormat(?string $format): static
    {
        return $this->with(DateIntervalNormalizer::FORMAT_KEY, $format);
    }
}
