<?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace RtmMailVendor\Dependencies\Symfony\Component\DependencyInjection\Loader\Configurator;

use RtmMailVendor\Dependencies\Symfony\Bundle\FrameworkBundle\KernelBrowser;
use RtmMailVendor\Dependencies\Symfony\Bundle\FrameworkBundle\Test\TestContainer;
use Symfony\Component\BrowserKit\CookieJar;
use Symfony\Component\BrowserKit\History;
use RtmMailVendor\Dependencies\Symfony\Component\DependencyInjection\ServiceLocator;
use RtmMailVendor\Dependencies\Symfony\Component\HttpKernel\EventListener\SessionListener;

return static function (ContainerConfigurator $container) {
    $container->parameters()->set('test.client.parameters', []);

    $container->services()
        ->set('test.client', KernelBrowser::class)
            ->args([
                service('kernel'),
                param('test.client.parameters'),
                service('test.client.history'),
                service('test.client.cookiejar'),
            ])
            ->share(false)
            ->public()

        ->set('test.client.history', History::class)->share(false)
        ->set('test.client.cookiejar', CookieJar::class)->share(false)

        ->set('test.session.listener', SessionListener::class)
            ->args([
                service_locator([
                    'session_factory' => service('session.factory')->ignoreOnInvalid(),
                ]),
                param('kernel.debug'),
                param('session.storage.options'),
            ])
            ->tag('kernel.event_subscriber')

        ->set('test.service_container', TestContainer::class)
            ->args([
                service('kernel'),
                'test.private_services_locator',
            ])
            ->public()

        ->set('test.private_services_locator', ServiceLocator::class)
            ->args([abstract_arg('callable collection')])
            ->public()
    ;
};
