<?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace RtmMailVendor\Dependencies\Symfony\Component\DependencyInjection\Loader\Configurator;

use RtmMailVendor\Dependencies\Symfony\Component\HttpKernel\EventListener\SurrogateListener;
use RtmMailVendor\Dependencies\Symfony\Component\HttpKernel\HttpCache\Ssi;

return static function (ContainerConfigurator $container) {
    $container->services()
        ->set('ssi', Ssi::class)

        ->set('ssi_listener', SurrogateListener::class)
            ->args([service('ssi')->ignoreOnInvalid()])
            ->tag('kernel.event_subscriber')
    ;
};
