<?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace RtmMailVendor\Dependencies\Symfony\Component\DependencyInjection\Loader\Configurator;

use Symfony\Component\Notifier\DataCollector\NotificationDataCollector;

return static function (ContainerConfigurator $container) {
    $container->services()
        ->set('notifier.data_collector', NotificationDataCollector::class)
            ->args([service('notifier.notification_logger_listener')])
            ->tag('data_collector', ['template' => '@WebProfiler/Collector/notifier.html.twig', 'id' => 'notifier'])
    ;
};
