<?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace RtmMailVendor\Dependencies\Symfony\Bundle\FrameworkBundle\CacheWarmer;

use RtmMailVendor\Dependencies\Psr\Container\ContainerInterface;
use RtmMailVendor\Dependencies\Symfony\Component\HttpKernel\CacheWarmer\CacheWarmerInterface;
use RtmMailVendor\Dependencies\Symfony\Component\HttpKernel\CacheWarmer\WarmableInterface;
use RtmMailVendor\Dependencies\Symfony\Component\Routing\RouterInterface;
use RtmMailVendor\Dependencies\Symfony\Contracts\Service\ServiceSubscriberInterface;

/**
 * Generates the router matcher and generator classes.
 *
 * @author Fabien Potencier <fabien@symfony.com>
 *
 * @final
 */
class RouterCacheWarmer implements CacheWarmerInterface, ServiceSubscriberInterface
{
    private ContainerInterface $container;

    public function __construct(ContainerInterface $container)
    {
        // As this cache warmer is optional, dependencies should be lazy-loaded, that's why a container should be injected.
        $this->container = $container;
    }

    public function warmUp(string $cacheDir, ?string $buildDir = null): array
    {
        $router = $this->container->get('router');

        if ($router instanceof WarmableInterface) {
            return (array) $router->warmUp($cacheDir, $buildDir);
        }

        throw new \LogicException(sprintf('The router "%s" cannot be warmed up because it does not implement "%s".', get_debug_type($router), WarmableInterface::class));
    }

    public function isOptional(): bool
    {
        return true;
    }

    public static function getSubscribedServices(): array
    {
        return [
            'router' => RouterInterface::class,
        ];
    }
}
