<?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace RtmMailVendor\Dependencies\Symfony\Bridge\Doctrine\Middleware\Debug;

use RtmMailVendor\Dependencies\Doctrine\DBAL\Driver as DriverInterface;
use RtmMailVendor\Dependencies\Doctrine\DBAL\Driver\Connection as ConnectionInterface;
use RtmMailVendor\Dependencies\Doctrine\DBAL\Driver\Middleware\AbstractDriverMiddleware;
use Symfony\Component\Stopwatch\Stopwatch;

/**
 * @author Laurent VOULLEMIER <laurent.voullemier@gmail.com>
 *
 * @internal
 */
final class Driver extends AbstractDriverMiddleware
{
    public function __construct(
        DriverInterface $driver,
        private readonly DebugDataHolder $debugDataHolder,
        private readonly ?Stopwatch $stopwatch,
        private readonly string $connectionName,
    ) {
        parent::__construct($driver);
    }

    public function connect(array $params): ConnectionInterface
    {
        $connection = parent::connect($params);

        if ('void' !== (string) (new \ReflectionMethod(DriverInterface\Connection::class, 'commit'))->getReturnType()) {
            return new DBAL3\Connection(
                $connection,
                $this->debugDataHolder,
                $this->stopwatch,
                $this->connectionName
            );
        }

        return new Connection(
            $connection,
            $this->debugDataHolder,
            $this->stopwatch,
            $this->connectionName
        );
    }
}
