<?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace RtmMailVendor\Dependencies\Symfony\Component\Cache\Adapter;

use RtmMailVendor\Dependencies\Psr\Cache\CacheItemPoolInterface;
use RtmMailVendor\Dependencies\Symfony\Component\Cache\CacheItem;

// Help opcache.preload discover always-needed symbols
class_exists(CacheItem::class);

/**
 * Interface for adapters managing instances of Symfony's CacheItem.
 *
 * @author Kévin Dunglas <dunglas@gmail.com>
 */
interface AdapterInterface extends CacheItemPoolInterface
{
    public function getItem(mixed $key): CacheItem;

    /**
     * @return iterable<string, CacheItem>
     */
    public function getItems(array $keys = []): iterable;

    public function clear(string $prefix = ''): bool;
}
