<?php
/**
 * @license MIT
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace RtmMailVendor\Dependencies\Scienta\DoctrineJsonFunctions\Query\AST\Functions\Mysql;

use RtmMailVendor\Dependencies\Doctrine\DBAL\Exception;
use RtmMailVendor\Dependencies\Doctrine\ORM\Query\Parser;
use RtmMailVendor\Dependencies\Doctrine\ORM\Query\TokenType;

/**
 * "JSON_CONTAINS_PATH" "(" StringPrimary "," ["one" | "all"] {"," StringPrimary }* ")"
 */
class JsonContainsPath extends JsonSearch
{
    public const FUNCTION_NAME = 'JSON_CONTAINS_PATH';

    /**
     * @param Parser $parser
     * @throws Exception
     * @throws \RtmMailVendor\Dependencies\Doctrine\ORM\Query\QueryException
     */
    public function parse(Parser $parser): void
    {
        $parser->match(TokenType::T_IDENTIFIER);
        $parser->match(TokenType::T_OPEN_PARENTHESIS);

        $this->parsedArguments[] = $parser->StringPrimary();

        $parser->match(TokenType::T_COMMA);

        $this->parsedArguments[] = $this->parsePathMode($parser);

        $this->parseOptionalArguments($parser, true);

        $parser->match(TokenType::T_CLOSE_PARENTHESIS);
    }
}
