<?php
/**
 * @license proprietary
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace RtmMailVendor\Dependencies\WordpressModels\Rest\Permissions;

use RtmMailVendor\Dependencies\Symfony\Component\ExpressionLanguage\ExpressionFunction;
use RtmMailVendor\Dependencies\Symfony\Component\ExpressionLanguage\ExpressionFunctionProviderInterface;

class RoleExpressionFunctionProvider implements ExpressionFunctionProviderInterface
{

    public function __construct(private readonly PermissionFunctionsInterface $permissionFunctions)
    {
    }

    public function compile(string $value): string
    {
        $class = $this->permissionFunctions::class;
        return "$class::userHasRole('$value')";
    }

    public function evaluate($args, $role): bool
    {
        return $this->permissionFunctions::userHasRole($role);
    }

    public function getFunctions(): array
    {
        return [
            new ExpressionFunction('role', $this->compile(...), $this->evaluate(...)),
        ];
    }
}