<?php
/**
 * @license proprietary
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace RtmMailVendor\Dependencies\WordpressModels\Rest\Permissions;

use Throwable;
use WP_REST_Request;

/**
 * Invokable class for processing permission expressions.
 * Should be hooked directly in the `permission_callback` argument for a `register_rest_route()` call
 */
class RequestPermissionEvaluator
{

    public function __construct(private readonly string $permissionExpression)
    {
    }

    public function __invoke(WP_REST_Request $request)
    {
        try {
            return PermissionExpressionLanguage::instance()
                ->getLanguage()
                ->evaluate($this->permissionExpression, $request->get_params());
        } catch (Throwable) {
            return false;
        }
    }

}
