<?php
/**
 * @license proprietary
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace RtmMailVendor\Dependencies\WordpressModels\Rest\Permissions;

use RtmMailVendor\Dependencies\Symfony\Component\ExpressionLanguage\ExpressionLanguage;
use RtmMailVendor\Dependencies\WordpressModels\Traits\SingletonTrait;

class PermissionExpressionLanguage
{

    use SingletonTrait;

    private readonly ExpressionLanguage $language;

    public function __construct(
        private readonly PermissionFunctionsInterface $permissionFunctions = new WordpressPermissionFunctions()
    )
    {
        $this->language = new ExpressionLanguage(null,
            [
                new RoleExpressionFunctionProvider($permissionFunctions),
                new AuthorizationExpressionFunctionProvider($permissionFunctions),
                new CapabilityExpressionFunctionProvider($permissionFunctions)
            ]);
    }

    public function evaluate(string $expression, array $routeParams)
    {
        return $this->language->evaluate($expression, $routeParams);
    }

    public function getLanguage(): ExpressionLanguage
    {
        return $this->language;
    }

}