<?php
/**
 * @license proprietary
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace RtmMailVendor\Dependencies\WordpressModels\Rest\Permissions;

use RtmMailVendor\Dependencies\Symfony\Component\ExpressionLanguage\ExpressionFunction;
use RtmMailVendor\Dependencies\Symfony\Component\ExpressionLanguage\ExpressionFunctionProviderInterface;

class AuthorizationExpressionFunctionProvider implements ExpressionFunctionProviderInterface
{

    public function __construct(private readonly PermissionFunctionsInterface $permissionFunctions)
    {
    }

    public function compileIsLoggedIn(): string
    {
        $class = $this->permissionFunctions::class;
        return "$class::isAuthorized()";
    }

    public function evaluateisLoggedIn(): bool
    {
        return $this->permissionFunctions::isAuthorized();
    }

    public function getFunctions(): array
    {
        return [
            new ExpressionFunction('is_authorized',
                $this->compileIsLoggedIn(...),
                $this->evaluateisLoggedIn(...)),
        ];
    }
}