<?php
/*
 * Copyright (c) 2023. RTM Business
 *
 * @license proprietary
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace RtmMailVendor\Dependencies\WordpressModels\ORM\WooCommerceEntity;

use RtmMailVendor\Dependencies\Doctrine\DBAL\Types\Types;
use RtmMailVendor\Dependencies\Doctrine\ORM\Mapping as ORM;

#[ORM\Entity]
#[ORM\Table(name: 'sessions')]
class Session
{
    #[ORM\Id]
    #[ORM\Column(name: 'session_id', type: Types::BIGINT, options: ['unsigned' => true])]
    #[ORM\GeneratedValue(strategy: 'IDENTITY')]
    private ?int $id = null;

    #[ORM\Column(name: 'session_key', type: Types::STRING, length: 32, options: ['notnull' => true])]
    private string $key;

    #[ORM\Column(name: 'session_value', type: Types::TEXT, options: ['notnull' => true])]
    private string $value;

    #[ORM\Column(name: 'session_expiry', type: Types::BIGINT, options: ['unsigned' => true, 'notnull' => true])]
    private int $expiry;

    /**
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @param int|null $id
     * @return Session
     */
    public function setId(?int $id): Session
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return string
     */
    public function getKey(): string
    {
        return $this->key;
    }

    /**
     * @param string $key
     * @return Session
     */
    public function setKey(string $key): Session
    {
        $this->key = $key;
        return $this;
    }

    /**
     * @return string
     */
    public function getValue(): string
    {
        return $this->value;
    }

    /**
     * @param string $value
     * @return Session
     */
    public function setValue(string $value): Session
    {
        $this->value = $value;
        return $this;
    }

    /**
     * @return int
     */
    public function getExpiry(): int
    {
        return $this->expiry;
    }

    /**
     * @param int $expiry
     * @return Session
     */
    public function setExpiry(int $expiry): Session
    {
        $this->expiry = $expiry;
        return $this;
    }

}