<?php
/*
 * Copyright (c) 2023. RTM Business
 *
 * @license proprietary
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace RtmMailVendor\Dependencies\WordpressModels\ORM\WooCommerceEntity;

use RtmMailVendor\Dependencies\Doctrine\ORM\Mapping\Entity;
use RtmMailVendor\Dependencies\Doctrine\ORM\Mapping\JoinColumn;
use RtmMailVendor\Dependencies\Doctrine\ORM\Mapping\ManyToOne;
use RtmMailVendor\Dependencies\Doctrine\ORM\Mapping\Table;
use RtmMailVendor\Dependencies\WordpressModels\ORM\Entity\AbstractMeta;

#[Entity]
#[Table(name: 'payment_tokenmeta')]
class PaymentTokenMeta extends AbstractMeta
{

    #[ManyToOne(targetEntity: PaymentToken::class)]
    #[JoinColumn(name: 'payment_token_id', referencedColumnName: 'token_id')]
    private PaymentToken $paymentToken;

    /**
     * @return PaymentToken
     */
    public function getPaymentToken(): PaymentToken
    {
        return $this->paymentToken;
    }

    /**
     * @param PaymentToken $paymentToken
     * @return PaymentTokenMeta
     */
    public function setPaymentToken(PaymentToken $paymentToken): PaymentTokenMeta
    {
        $this->paymentToken = $paymentToken;
        return $this;
    }

    public static function getType(): string
    {
        return 'payment_token';
    }

}