<?php
/*
 * Copyright (c) 2023. RTM Business
 *
 * @license proprietary
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace RtmMailVendor\Dependencies\WordpressModels\ORM\WooCommerceEntity;

use RtmMailVendor\Dependencies\Doctrine\ORM\Mapping\Entity;
use RtmMailVendor\Dependencies\Doctrine\ORM\Mapping\JoinColumn;
use RtmMailVendor\Dependencies\Doctrine\ORM\Mapping\ManyToOne;
use RtmMailVendor\Dependencies\Doctrine\ORM\Mapping\Table;
use RtmMailVendor\Dependencies\WordpressModels\ORM\Entity\AbstractMeta;


/**
 * Doctrine Entity matching the wp_woocommerce_order_itemmeta table.
 */
#[Entity]
#[Table(name: 'order_itemmeta')]
class OrderItemMeta extends AbstractMeta
{

    #[ManyToOne(targetEntity: OrderItem::class, inversedBy: 'meta')]
    #[JoinColumn(name: 'order_item_id', referencedColumnName: 'order_item_id')]
    private OrderItem $orderItem;

    /**
     * @return OrderItem
     */
    public function getOrderItem(): OrderItem
    {
        return $this->orderItem;
    }

    /**
     * @param OrderItem $orderItem
     * @return OrderItemMeta
     */
    public function setOrderItem(OrderItem $orderItem): OrderItemMeta
    {
        $this->orderItem = $orderItem;
        return $this;
    }

    public static function getType(): string
    {
        return 'order_item';
    }
}
