<?php
/*
 * Copyright (c) 2023. RTM Business
 *
 * @license proprietary
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace RtmMailVendor\Dependencies\WordpressModels\ORM;

use RtmMailVendor\Dependencies\WordpressModels\ORM\WooCommerceEntity\AdminNote;
use RtmMailVendor\Dependencies\WordpressModels\ORM\WooCommerceEntity\AdminNoteAction;
use RtmMailVendor\Dependencies\WordpressModels\ORM\WooCommerceEntity\ApiKey;
use RtmMailVendor\Dependencies\WordpressModels\ORM\WooCommerceEntity\AttributeTaxonomy;
use RtmMailVendor\Dependencies\WordpressModels\ORM\WooCommerceEntity\DownloadableProductPermission;
use RtmMailVendor\Dependencies\WordpressModels\ORM\WooCommerceEntity\Log;
use RtmMailVendor\Dependencies\WordpressModels\ORM\WooCommerceEntity\OrderItem;
use RtmMailVendor\Dependencies\WordpressModels\ORM\WooCommerceEntity\OrderItemMeta;
use RtmMailVendor\Dependencies\WordpressModels\ORM\WooCommerceEntity\PaymentToken;
use RtmMailVendor\Dependencies\WordpressModels\ORM\WooCommerceEntity\PaymentTokenMeta;
use RtmMailVendor\Dependencies\WordpressModels\ORM\WooCommerceEntity\PostType\Product;
use RtmMailVendor\Dependencies\WordpressModels\ORM\WooCommerceEntity\PostType\ShopOrder;
use RtmMailVendor\Dependencies\WordpressModels\ORM\WooCommerceEntity\Session;
use RtmMailVendor\Dependencies\WordpressModels\ORM\WooCommerceEntity\ShippingZone;
use RtmMailVendor\Dependencies\WordpressModels\ORM\WooCommerceEntity\ShippingZoneMethods;
use RtmMailVendor\Dependencies\WordpressModels\ORM\WooCommerceEntity\TaxRate;
use RtmMailVendor\Dependencies\WordpressModels\ORM\WooCommerceEntity\TaxRateLocation;
use RtmMailVendor\Dependencies\WordpressModels\Traits\SingletonTrait;

class WooCommerceEntities
{

    use SingletonTrait;

    public function __construct()
    {
        add_filter('doctrine_entity_directories', $this->addEntityDirectories(...));
        add_filter('doctrine_post_type_discriminator_map', $this->addPostTypeDiscriminators(...));
        add_filter('doctrine_plugin_entity_table_prefixes', $this->setWoocommercePrefixes(...));
    }

    public function addEntityDirectories(array $directories): array
    {
        return [...$directories, realpath(__DIR__ . '/WooCommerceEntity')];
    }

    public function addPostTypeDiscriminators(array $classMap): array
    {
        return $classMap + [
                'product' => Product::class,
                'shop_order' => ShopOrder::class
            ];
    }

    /**
     * Set the prefixes for WooCommerce entities.
     *
     * @param array $classMap
     * @return array
     */
    public function setWoocommercePrefixes(array $classMap): array
    {
        $longPrefixEntities = [
            ApiKey::class,
            AttributeTaxonomy::class,
            DownloadableProductPermission::class,
            Log::class,
            OrderItem::class,
            OrderItemMeta::class,
            PaymentToken::class,
            PaymentTokenMeta::class,
            Session::class,
            ShippingZone::class,
            ShippingZoneMethods::class,
            TaxRate::class,
            TaxRateLocation::class
        ];
        foreach ($longPrefixEntities as $entityClass) {
            $classMap[$entityClass] = 'woocommerce';
        }

        $shortPrefixEntities = [
            AdminNote::class,
            AdminNoteAction::class,
        ];

        foreach ($shortPrefixEntities as $entityClass) {
            $classMap[$entityClass] = 'wc';
        }

        return $classMap;
    }

}
