<?php
/**
 * @license proprietary
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace RtmMailVendor\Dependencies\WordpressModels\ORM\Migrations;

use RtmMailVendor\Dependencies\Doctrine\DBAL\Platforms\MySQL80Platform;
use RtmMailVendor\Dependencies\Doctrine\DBAL\Schema\MySQLSchemaManager;
use Doctrine\Migrations\Configuration\Connection\ExistingConnection;
use Doctrine\Migrations\DependencyFactory;
use RtmMailVendor\Dependencies\Doctrine\ORM\EntityManagerInterface;
use RtmMailVendor\Dependencies\Doctrine\ORM\Mapping\Driver\DatabaseDriver;
use RtmMailVendor\Dependencies\WordpressModels\ORM\Command\DatabaseSchemaTool;

class MigrationsTool
{

    public function __construct(private EntityManagerInterface $em)
    {
        $tool = new DatabaseSchemaTool($em, $this->getEnhancedSchemaManager($em));
    }

    /**
     * @return string[]
     * @throws \RtmMailVendor\Dependencies\Doctrine\DBAL\Exception
     */
    public function getMigrationLines(): array
    {
        $dependencyFactory = DependencyFactory::fromEntityManager(
            $this->em,
            new DatabaseDriver($schemaManager),
            new ExistingConnection($connection),
        );

        $schemaDumper = $dependencyFactory->getSchemaDumper();
        $nameGenerator = $dependencyFactory->getClassNameGenerator();
        $className = $nameGenerator->generateClassName($metadata);
        $schemaDumper->dump('App\Migrations\Version20211010101010', [], true, 120);
    }

    /**
     * Get an enhanced schema manager that can handle the enum type.
     *
     * @param EntityManagerInterface $entityManager
     * @return DatabaseDriver
     * @throws \RtmMailVendor\Dependencies\Doctrine\DBAL\Exception
     */
    private function getEnhancedSchemaManager(EntityManagerInterface $entityManager): MySQLSchemaManager
    {
        $platform = new MySQL80Platform();
        $platform->registerDoctrineTypeMapping('enum', 'string');

        return new MySQLSchemaManager($entityManager->getConnection(), $platform);
    }



}