<?php
/*
 * Copyright (c) 2023. RTM Business
 *
 * @license proprietary
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace RtmMailVendor\Dependencies\WordpressModels\ORM\EntityTrait;

use DateTime;
use RtmMailVendor\Dependencies\Doctrine\ORM\Events;
use RtmMailVendor\Dependencies\Doctrine\ORM\Mapping\Column;
use RtmMailVendor\Dependencies\Symfony\Component\Serializer\Annotation\Groups;
use RtmMailVendor\Dependencies\WordpressModels\ORM\Attributes\Timestamp;

trait SoftDeletable
{

    #[Column(type: 'datetime', nullable: true)]
    #[Groups(['read_timestamps'])]
    #[Timestamp(Events::preRemove)]
    protected ?DateTime $deletedAt = null;


    /**
     * @return DateTime|null
     */
    public function getDeletedAt(): ?DateTime
    {
        return $this->deletedAt;
    }

    /**
     * @param DateTime|null $deletedAt
     * @return self
     */
    public function setDeletedAt(?DateTime $deletedAt): self
    {
        $this->deletedAt = $deletedAt;
        return $this;
    }
}