<?php
/**
 * @license proprietary
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace RtmMailVendor\Dependencies\WordpressModels\ORM\Entity;

use RtmMailVendor\Dependencies\Doctrine\DBAL\Types\Types;
use RtmMailVendor\Dependencies\Doctrine\ORM\Mapping as ORM;
use RtmMailVendor\Dependencies\Symfony\Component\Serializer\Attribute\Groups;

/**
 * Entity mapping for the WordPress `options` table.
 *
 * Serialization groups:
 * - read_option -- for reading options.
 */
#[
    ORM\Table('options'),
    ORM\Index(['autoload'], name: 'autoload'),
    ORM\UniqueConstraint(name: 'option_name', columns: ['option_name']),
    ORM\Entity,
    ORM\Cache(usage: 'NONSTRICT_READ_WRITE', region: 'wp_options'),
]
class Option
{

    #[ORM\Column(name: 'option_id', type: Types::BIGINT, options: ['unsigned' => true])]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'IDENTITY')]
    #[Groups('read_option')]
    private ?int $id = null;

    #[ORM\Column(name: 'option_name', type: Types::STRING, length: 191, nullable: false, options: ['default' => ''])]
    #[Groups('read_option')]
    private string $name = '';

    /**
     * @var string
     */
    #[ORM\Column(name: 'option_value', type: Types::TEXT, length: 0, nullable: false)]
    #[Groups('read_option')]
    private ?string $value = null;

    /**
     * @todo: ENUM [yes, no]
     */
    #[ORM\Column(name: 'autoload', type: Types::STRING, length: 20, options: ['default' => 'yes'])]
    #[Groups('read_option')]
    private string $autoload = 'yes';

    public function getId(): ?string
    {
        return $this->id;
    }

    public function setId(?string $id): Option
    {
        $this->id = $id;
        return $this;
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function setName(string $name): Option
    {
        $this->name = $name;
        return $this;
    }

    public function getValue(): ?string
    {
        return $this->value;
    }

    public function setValue(?string $value): Option
    {
        $this->value = $value;
        return $this;
    }

    public function getAutoload(): string
    {
        return $this->autoload;
    }

    public function setAutoload(string $autoload): Option
    {
        $this->autoload = $autoload;
        return $this;
    }

}
