<?php
/*
 * Copyright (c) 2023. RTM Business
 *
 * @license proprietary
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace RtmMailVendor\Dependencies\WordpressModels\ORM\Entity;

use RtmMailVendor\Dependencies\Doctrine\Common\Collections\Collection;

/**
 * Trait used to get meta values from a collection of meta entities.
 *
 * The {@see self::getMetaValue()} method is used to get the value of a meta key from the collection of meta entities.
 *
 * @template T of AbstractMeta
 * @property Collection<T> $meta
 */
trait GetMetaValueTrait
{

    /**
     * @param string $key
     * @return mixed
     */
    public function getMetaValue(string $key): mixed
    {
        return $this->meta->findFirst(fn($idx, AbstractMeta $meta) => $meta->getKey() === $key)?->getValueDeserialized();
    }

}