<?php
/**
 * @license proprietary
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace RtmMailVendor\Dependencies\WordpressModels\DependencyInjection\Metabox;

use WP_Post;

interface MetaboxInterface
{

    const CONTEXTS = ['normal', 'side', 'advanced'];
    const PRIORITIES = ['high', 'core', 'default', 'low'];

    /**
     * Render function.
     *
     * Should echo the contents of the metabox.
     *
     * @param WP_Post|null $post
     *
     * @return void
     */
    public function renderMetaBox(?WP_Post $post): void;

}
