<?php
/**
 * @license proprietary
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace RtmMailVendor\Dependencies\WordpressModels\DependencyInjection\Initializer;

use RtmMailVendor\Dependencies\Symfony\Component\DependencyInjection\Container;

/**
 * ServiceInitializer
 *
 * This class is responsible for initializing services that are tagged with the `force_initialize` tag.
 */
class ServiceInitializer
{

    private array $serviceIds = [];

    public function __construct(private Container $container)
    {
    }

    public function initializeServices()
    {
        foreach ($this->serviceIds as $id) {
            $this->container->get($id);
        }
    }

    public function addService(string $id): void
    {
        $this->serviceIds[] = $id;
    }

}