<?php
/**
 * @license proprietary
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace RtmMailVendor\Dependencies\WordpressModels\DependencyInjection\Initializer;

use RtmMailVendor\Dependencies\Symfony\Component\DependencyInjection\ContainerBuilder;
use RtmMailVendor\Dependencies\Symfony\Component\DependencyInjection\Definition;
use RtmMailVendor\Dependencies\Symfony\Component\DependencyInjection\Extension\Extension;
use RtmMailVendor\Dependencies\WordpressModels\DependencyInjection\Initializer\Attributes\ForceInitialize;

class InitializerExtension extends Extension
{


    public function load(array $configs, ContainerBuilder $container)
    {
        $container->registerAttributeForAutoconfiguration(ForceInitialize::class, self::tagForceInitialize(...));
    }

    public static function tagForceInitialize(Definition $definition): void
    {
        // prevent auto-removal due to the service being private
        $definition->setPublic(true);
        // set non-lazy
        $definition->setLazy(false);

        // tag the service
        $definition->addTag('force_initialize');
    }

}