<?php
/**
 * @license proprietary
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace RtmMailVendor\Dependencies\WordpressModels\DependencyInjection\Initializer;

use RtmMailVendor\Dependencies\Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use RtmMailVendor\Dependencies\Symfony\Component\DependencyInjection\ContainerBuilder;

class InitializerCompilerPass implements CompilerPassInterface
{


    public function process(ContainerBuilder $container)
    {
        $initializer = $container->getDefinition(ServiceInitializer::class);
        $services = $container->findTaggedServiceIds('force_initialize');

        foreach ($services as $id => $tags) {
            $initializer->addMethodCall('addService', [$id]);
        }
    }
}