<?php
/**
 * @license proprietary
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace RtmMailVendor\Dependencies\WordpressModels\DependencyInjection\HookAttributes\Attributes;

/**
 * Attribute to mark a method as a WordPress Ajax action.
 *
 * When using this attribute, omit the 'wp_ajax_' and 'wp_ajax_nopriv_' prefixes. The attribute will add these prefixes
 * automatically.
 *
 * Automatic nonce verification is added when the $nonceId is set.
 *
 * A method attributed with this attribute must have a {@see \Symfony\Component\HttpFoundation\Request} as the first
 * parameter. The method must return any json serializable value, as responses are sent using {@see wp_send_json_success}
 * and {@see wp_send_json_error}.
 */
#[\Attribute(\Attribute::TARGET_METHOD | \Attribute::TARGET_CLASS | \Attribute::IS_REPEATABLE)]
class AjaxAction extends Hook
{

    public function __construct(string                  $hook,
                                int                     $priority = 10,
                                public readonly bool    $private = true,
                                public readonly bool    $public = false,
                                public readonly ?string $nonceId = null,
                                public readonly string  $nonceKey = 'nonce'
    )
    {
        parent::__construct('action', $hook, $priority, 0);
    }

}