<?php
/**
 * @license proprietary
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace RtmMailVendor\Dependencies\WordpressModels\DependencyInjection\Doctrine;



use RtmMailVendor\Dependencies\Doctrine\Bundle\DoctrineBundle\Attribute\AsDoctrineListener;
use RtmMailVendor\Dependencies\Doctrine\Bundle\DoctrineBundle\Attribute\AsEntityListener;
use RtmMailVendor\Dependencies\Doctrine\Bundle\DoctrineBundle\Attribute\AsMiddleware;
use RtmMailVendor\Dependencies\Doctrine\Bundle\DoctrineBundle\DependencyInjection\Compiler\IdGeneratorPass;
use RtmMailVendor\Dependencies\Doctrine\Bundle\DoctrineBundle\DependencyInjection\Compiler\ServiceRepositoryCompilerPass;
use RtmMailVendor\Dependencies\Doctrine\Bundle\DoctrineBundle\EventSubscriber\EventSubscriberInterface;
use RtmMailVendor\Dependencies\Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepositoryInterface;
use RtmMailVendor\Dependencies\Doctrine\DBAL\Driver\Middleware as MiddlewareInterface;
use RtmMailVendor\Dependencies\Doctrine\ORM\Id\AbstractIdGenerator;
use RtmMailVendor\Dependencies\Symfony\Component\DependencyInjection\ChildDefinition;
use RtmMailVendor\Dependencies\Symfony\Component\DependencyInjection\ContainerBuilder;
use RtmMailVendor\Dependencies\Symfony\Component\DependencyInjection\Extension\Extension;

class
WordpressDoctrineExtension extends Extension
{
    
    
    public function load(array $configs, ContainerBuilder $container)
    {
        $container->registerForAutoconfiguration(ServiceEntityRepositoryInterface::class)
            ->addTag(ServiceRepositoryCompilerPass::REPOSITORY_SERVICE_TAG);

        $container->registerForAutoconfiguration(EventSubscriberInterface::class)
            ->addTag('doctrine.event_subscriber');

        $container->registerForAutoconfiguration(AbstractIdGenerator::class)
            ->addTag(IdGeneratorPass::ID_GENERATOR_TAG);

        $container->registerAttributeForAutoconfiguration(AsEntityListener::class, static function (ChildDefinition $definition, AsEntityListener $attribute) {
            $definition->addTag('doctrine.orm.entity_listener', [
                'event'          => $attribute->event,
                'method'         => $attribute->method,
                'lazy'           => $attribute->lazy,
                'entity_manager' => $attribute->entityManager,
                'entity'         => $attribute->entity,
                'priority'       => $attribute->priority,
            ]);
        });
        $container->registerAttributeForAutoconfiguration(AsDoctrineListener::class, static function (ChildDefinition $definition, AsDoctrineListener $attribute) {
            $definition->addTag('doctrine.event_listener', [
                'event'      => $attribute->event,
                'priority'   => $attribute->priority,
                'connection' => $attribute->connection,
            ]);
        });

        $container->registerForAutoconfiguration(MiddlewareInterface::class)->addTag('doctrine.middleware');

        $container->registerAttributeForAutoconfiguration(AsMiddleware::class, static function (ChildDefinition $definition, AsMiddleware $attribute) {
            $priority = isset($attribute->priority) ? ['priority' => $attribute->priority] : [];

            if ($attribute->connections === []) {
                $definition->addTag('doctrine.middleware', $priority);

                return;
            }

            foreach ($attribute->connections as $connName) {
                $definition->addTag('doctrine.middleware', array_merge($priority, ['connection' => $connName]));
            }
        });

        $this->registerMetaListenerHooks($container);
    }

    private function registerMetaListenerHooks(ContainerBuilder $container)
    {

    }

}