<?php
/**
 * @license proprietary
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace RtmMailVendor\Dependencies\WordpressModels\DependencyInjection\CliCommandAttributes;

use RtmMailVendor\Dependencies\WordpressModels\DependencyInjection\HookAttributes\Attributes\Action;

class WpCliCommandRegistry
{

    /**
     * @var array{
     *     name: string,
     *     callback: string,
     *     args: array
     * }[]
     */
    private array $commands = [];

    #[Action('cli_init')]
    public function initCommands()
    {
        foreach ($this->commands as $name => $command) {
            \WP_CLI::add_command($name, $command['callback'], $command['args']);
        }
    }

    public function addCommand(string $name, callable $callback, array $args)
    {
        $this->commands[$name] = [
            'callback' => $callback,
            'args' => $args,
        ];
    }

    /**
     * @return array
     */
    public function getCommands(): array
    {
        return $this->commands;
    }

}