<?php
/**
 * @license MIT
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace RtmMailVendor\Dependencies\SPFLib\Semantic;

use RtmMailVendor\Dependencies\SPFLib\Record;

/**
 * Class that represent a semantic issue reported by SemanticVamidator.
 */
class Issue extends AbstractIssue
{
    /**
     * The affected record.
     *
     * @var \RtmMailVendor\Dependencies\SPFLib\Record
     */
    private $record;

    /**
     * Initialize the instance.
     */
    public function __construct(Record $record, int $code, string $description, int $level)
    {
        parent::__construct($code, $description, $level);
        $this->record = $record;
    }

    /**
     * {@inheritdoc}
     *
     * @see \RtmMailVendor\Dependencies\SPFLib\Semantic\AbstractIssue::__toString()
     */
    public function __toString(): string
    {
        $level = $this->getLevelDescription();

        return $level === '' ? $this->getDescription() : "[{$level}] {$this->getDescription()}";
    }

    /**
     * Get the affected record.
     */
    public function getRecord(): Record
    {
        return $this->record;
    }
}
