<?php
/**
 * @license MIT
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace RtmMailVendor\Dependencies\SPFLib\Exception;

use RtmMailVendor\Dependencies\SPFLib\Exception;

/**
 * Exception thrown when a value doesn't represent a valid IPv4/IPv6 address.
 */
class InvalidIPAddressException extends Exception
{
    /**
     * The the wrong IP address.
     *
     * @var string|mixed
     */
    private $wrongIPAddress;

    /**
     * Initialize the instance.
     *
     * @param string|mixed $wrongIPAddress the wrong IP address
     */
    public function __construct($wrongIPAddress)
    {
        $type = gettype($wrongIPAddress);
        parent::__construct($type === 'string' ? "'{$wrongIPAddress}' is not a valid IPv4/IPv6 address" : "Expected a string to represent an address, received a {$type}");
        $this->wrongIPAddress = $wrongIPAddress;
    }

    /**
     * Get the wrong IP address.
     */
    public function getWrongIPAddress(): string
    {
        return $this->wrongIPAddress;
    }
}
