<?php
/**
 * @license MIT
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace RtmMailVendor\Dependencies\SPFLib\Check\State;

use RtmMailVendor\Dependencies\SPFLib\Check\State;

/**
 * Class that holds the state of the "HELO"/"EHLO" check process.
 */
class HeloDomainState extends State
{
    /**
     * {@inheritdoc}
     *
     * @see \RtmMailVendor\Dependencies\SPFLib\Check\State::getSender()
     */
    public function getSender(): string
    {
        $domain = $this->getEnvironment()->getHeloDomain();

        return $domain === '' ? '' : "postmaster@{$domain}";
    }
}
