<?php
/**
 * @license MIT
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace RtmMailVendor\Dependencies\MLocati\IDNA\IdnaMapping\Range;

use Exception;
use RtmMailVendor\Dependencies\MLocati\IDNA\IdnaMapping\TableRow;

/**
 * The code point is not allowed.
 */
class Disallowed extends Range
{
    /**
     * Initializes the instance.
     *
     * @param \RtmMailVendor\Dependencies\MLocati\IDNA\IdnaMapping\TableRow $row
     *
     * @throws \Exception
     */
    public function __construct(TableRow $row)
    {
        parent::__construct($row);
        if ($row->mapping !== null) {
            throw new Exception('Mapping field unexpected in disallowed ranges');
        }
        if ($row->statusIDNA2008 !== '') {
            throw new Exception('IDNA2008 status field unexpected in disallowed ranges');
        }
    }

    /**
     * {@inheritdoc}
     *
     * @see \RtmMailVendor\Dependencies\MLocati\IDNA\IdnaMapping\Range\Range::isCompatibleWith()
     */
    protected function isCompatibleWith(Range $range)
    {
        return $range instanceof self;
    }
}
