<?php
/**
 * @license MIT
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */ declare(strict_types=1);

namespace RtmMailVendor\Dependencies\Jawira\CaseConverter\Split;

class UppercaseSplitter extends Splitter
{
    // language=PhpRegExp
    public const PATTERN = '#(?=\p{Lu}{1})#u';

    /**
     * Splits $words using Uppercase letters.
     *
     * @see https://www.regular-expressions.info/unicode.html#category
     * @return string[] Words in $input
     * @throws \RtmMailVendor\Dependencies\Jawira\CaseConverter\CaseConverterException
     */
    public function split(): array
    {
        return $this->splitUsingPattern($this->inputString, self::PATTERN);
    }
}
