<?php
/**
 * @license MIT
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */ declare(strict_types=1);

namespace RtmMailVendor\Dependencies\Jawira\CaseConverter\Split;

use RtmMailVendor\Dependencies\Jawira\CaseConverter\Glue\DashGluer;

class DashSplitter extends Splitter
{
    /** @internal */
    public const PATTERN = '#' . DashGluer::DELIMITER . '+#u';

    /**
     * @return string[]
     * @throws \RtmMailVendor\Dependencies\Jawira\CaseConverter\CaseConverterException
     */
    public function split(): array
    {
        return $this->splitUsingPattern($this->inputString, self::PATTERN);
    }
}
