<?php
/**
 * @license MIT
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */ declare(strict_types=1);

namespace RtmMailVendor\Dependencies\Jawira\CaseConverter\Glue;

/**
 * Class KebabCase
 *
 * Outputs string in _Cobol case_ format: this-is-kebab-case
 */
class KebabCase extends DashGluer
{
    /**
     * Format detected words in _Kebab case_
     *
     * @return string
     */
    public function glue(): string
    {
        return $this->glueUsingRules(self::DELIMITER, $this->lowerCase);
    }
}
