<?php
/**
 * @license MIT
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */ declare(strict_types=1);

namespace RtmMailVendor\Dependencies\Jawira\CaseConverter\Glue;

/**
 * Class CamelCase
 *
 * Outputs string in _Camel case_ format: thisIsCamelCase
 */
class CamelCase extends UppercaseGluer
{
    /**
     * Format detected words in _Camel case_
     *
     * @return string
     */
    public function glue(): string
    {
        return $this->glueUsingRules(self::DELIMITER, $this->titleCase, $this->lowerCase);
    }
}
