<?php
/**
 * @license MIT
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace RtmMailVendor\Dependencies\Doctrine\SqlFormatter;

final class NullHighlighter implements Highlighter
{
    public function highlightToken(int $type, string $value): string
    {
        return $value;
    }

    public function highlightError(string $value): string
    {
        return $value;
    }

    public function highlightErrorMessage(string $value): string
    {
        return ' ' . $value;
    }

    public function output(string $string): string
    {
        return $string;
    }
}
