<?php
/**
 * @license MIT
 *
 * Modified by RTM Business on 16-December-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace RtmMailVendor\Dependencies\Doctrine\Persistence\Mapping;

use RtmMailVendor\Dependencies\Doctrine\Persistence\Proxy;

interface ProxyClassNameResolver
{
    /**
     * @psalm-param class-string<Proxy<T>>|class-string<T> $className
     *
     * @psalm-return class-string<T>
     *
     * @template T of object
     */
    public function resolveClassName(string $className): string;
}
